<?php
require_once 'includes/authors.php';

function generateMenu($links, $domainZone, $currentLevel = null, $currentIndex = null) {
    $menuLinks = '<ul>';
    $authors = getAuthorsByDomain($_SERVER['HTTP_HOST']);

    // Добавляем карту сайта
    $menuLinks .= '<li><a href="/sitemap/">Карта сайта</a></li>';

    $output = ''; // финальный вывод всех пунктов меню
    $i = 0;

    while ($i < count($links)) {
        $link = $links[$i];

        if ($link['Level'] == 2) {
            $linkAnchor = str_replace(['%author%', '%editor%', '%contributor%'], [$authors['author'], $authors['editor'], $authors['contributor']], $link['Anchor']);
            $page = str_replace(['%author%', '%editor%', '%contributor%'], [$authors['author'], $authors['editor'], $authors['contributor']], $link['Page']);
            $pageUrl = $page === '/' ? '/' : '/' . ltrim($page, '/') . '-' . $domainZone . '/';

            // Проверяем — нужно ли добавить Level 3 под этим Level 2?
            $level3List = '';
            if (
                ($currentLevel == 2 && $i == $currentIndex) || // если открыта эта Level 2
                ($currentLevel == 3 && findParentLevel2($links, $currentIndex) === $i) // или эта Level 2 — родитель открытой Level 3
            ) {
                $subLinks = [];

                for ($j = $i + 1; $j < count($links); $j++) {
                    if ($links[$j]['Level'] == 2) break;
                    if ($links[$j]['Level'] == 3) {
                        $subAnchor = str_replace(['%author%', '%editor%', '%contributor%'], [$authors['author'], $authors['editor'], $authors['contributor']], $links[$j]['Anchor']);
                        $subPage = str_replace(['%author%', '%editor%', '%contributor%'], [$authors['author'], $authors['editor'], $authors['contributor']], $links[$j]['Page']);
                        $subPageUrl = '/' . ltrim($subPage, '/') . '-' . $domainZone . '/';
                        $subLinks[] = "<li><a href=\"$subPageUrl\">$subAnchor</a></li>";
                    }
                }

                if (!empty($subLinks)) {
                    $level3List = '<ul>' . implode('', $subLinks) . '</ul>';
                }
            }

            $output .= "<li><a href=\"$pageUrl\">$linkAnchor</a>$level3List</li>";
        }

        $i++;
    }

    $menuLinks .= $output;

    // Старое поведение — отображение соседей Level 3
    if ($currentLevel == 3 && $currentIndex !== null) {
        $siblingLinks = [];

        // Сначала выше
        for ($i = $currentIndex - 1; $i >= 0; $i--) {
            if ($links[$i]['Level'] == 2) break;
            if ($links[$i]['Level'] == 3) {
                $siblingAnchor = str_replace(['%author%', '%editor%', '%contributor%'], [$authors['author'], $authors['editor'], $authors['contributor']], $links[$i]['Anchor']);
                $siblingPage = str_replace(['%author%', '%editor%', '%contributor%'], [$authors['author'], $authors['editor'], $authors['contributor']], $links[$i]['Page']);
                $siblingPageUrl = '/' . ltrim($siblingPage, '/') . '-' . $domainZone . '/';
                array_unshift($siblingLinks, "<li><a href=\"$siblingPageUrl\">$siblingAnchor</a></li>");
            }
        }

        // Затем ниже
        for ($i = $currentIndex + 1; $i < count($links); $i++) {
            if ($links[$i]['Level'] == 2) break;
            if ($links[$i]['Level'] == 3) {
                $siblingAnchor = str_replace(['%author%', '%editor%', '%contributor%'], [$authors['author'], $authors['editor'], $authors['contributor']], $links[$i]['Anchor']);
                $siblingPage = str_replace(['%author%', '%editor%', '%contributor%'], [$authors['author'], $authors['editor'], $authors['contributor']], $links[$i]['Page']);
                $siblingPageUrl = '/' . ltrim($siblingPage, '/') . '-' . $domainZone . '/';
                $siblingLinks[] = "<li><a href=\"$siblingPageUrl\">$siblingAnchor</a></li>";
            }
        }

        if (!empty($siblingLinks)) {
            $menuLinks .= '<ul>' . implode('', $siblingLinks) . '</ul>';
        }
    }

    $menuLinks .= '</ul>';
    return $menuLinks;
}

// 🔎 Вспомогательная функция — ищет индекс Level 2 выше текущего
function findParentLevel2($links, $startIndex) {
    for ($i = $startIndex - 1; $i >= 0; $i--) {
        if ($links[$i]['Level'] == 2) {
            return $i;
        }
    }
    return null;
}
